import 'package:flutter/material.dart';
import 'package:fluttericon/zocial_icons.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/components/pea_app_bar.dart';
import 'package:peasmartcare/components/profile_avatar.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/models/coordinator_position_model.dart';

class ProfilePage extends StatefulWidget {
  @override
  _ProfilePageState createState() => _ProfilePageState();
}

class _ProfilePageState extends State<ProfilePage> {
  final _formKey = GlobalKey<FormState>();
  String _positionValue;
  String _positionName;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: PEAAppBar(
        title: "แก้ไขข้อมูลส่วนตัว",
        actions: <Widget>[
          ProfileAvatar(disableEditProfile: true),
        ],
      ),
      body: BodyLayout(
        top: 0,
        layoutType: LayoutType.ONLY_CHILD,
        child: Column(
          children: <Widget>[
            Stack(
              children: <Widget>[
                // HeaderContent(
                //   title: "แก้ไขข้อมูลส่วนตัว",
                //   icon: ImageAsset.contactStaffImg,
                // ),
                // ClipPath(
                //   clipper: OvalBottomBorderClipper(),
                //   child: Container(
                //     margin: const EdgeInsets.only(top: 0),
                //     height: 380,
                //     decoration: BoxDecoration(
                //       color: Colors.pink,
                //     ),
                //   ),
                // ),
                _body(),
              ],
            ),
          ],
        ),
      ),
    );
  }

  Widget _body() {
    TextStyle textStyle = TextStyle(color: Color(AppData.primaryColor), fontSize: 18);
    TextStyle errortyle = TextStyle(color: Colors.red[900], fontSize: 18);
    List<CoordinatorPositionModel> _positionList = List<CoordinatorPositionModel>();
    _positionList.add(CoordinatorPositionModel(id: "1", name: "ผู้จัดการ"));
    _positionList.add(CoordinatorPositionModel(id: "2", name: "โปรแกรมเมอร์"));
    _positionList.add(CoordinatorPositionModel(id: "3", name: "ผู้ช่วยผู้จัดการ"));

    return Positioned(
      child: Padding(
        padding: const EdgeInsets.only(top: 40),
        child: Container(
          height: 800,
          child: Center(
            child: Column(
              children: <Widget>[
                _buildAvatar(ImageAsset.imageDefaultAvartar),
                SizedBox(height: 50),
                Text(
                  "กุลวุฒิ  วิทิตศานต์",
                  style: TextStyle(
                    color: Color(AppData.purpleColor),
                    fontSize: 30,
                  ),
                ),
                SizedBox(height: 40),
                Form(
                  key: _formKey,
                  child: Container(
                    constraints: BoxConstraints(maxWidth: 500),
                    child: Column(
                      children: <Widget>[
                        Container(
                          height: 85,
                          padding: EdgeInsets.only(left: 30, right: 30),
                          child: DropdownButtonFormField<dynamic>(
                            validator: (value) {
                              if (value == null || value.isEmpty) {
                                return "กรุณาเลือกตำแหน่ง";
                              }
                              return null;
                            },
                            decoration: InputDecoration(
                              hintText: "ตำแหน่ง",
                              hintStyle: textStyle,
                              labelText: "ตำแหน่ง",
                              labelStyle: textStyle,
                              errorStyle: errortyle,
                              floatingLabelBehavior: FloatingLabelBehavior.auto,
                              filled: true,
                              fillColor: Color(AppData.whiteColor),
                              contentPadding: EdgeInsets.symmetric(vertical: 0, horizontal: 15),
                              border: OutlineInputBorder(
                                borderRadius: const BorderRadius.all(
                                  const Radius.circular(30),
                                ),
                              ),
                            ),
                            value: _positionValue,
                            isExpanded: true,
                            onChanged: (val) {
                              CoordinatorPositionModel position = _positionList.singleWhere((item) => item.id == val);

                              setState(() {
                                _positionValue = val;
                                _positionName = position.name;
                              });
                            },
                            items: _positionList.map<DropdownMenuItem<dynamic>>(
                              (value) {
                                return DropdownMenuItem<dynamic>(
                                  value: value.id,
                                  child: Text(
                                    value.name,
                                    style: textStyle,
                                  ),
                                );
                              },
                            ).toList(),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
                Padding(
                  padding: const EdgeInsets.fromLTRB(10, 5, 10, 0),
                  child: ListTile(
                    title: Text("เบอร์โทรศัพท์", style: textStyle),
                    subtitle: Text("0832214453"),
                    leading: Icon(
                      Icons.phone,
                      color: Color(AppData.purpleColor),
                    ),
                  ),
                ),
                Padding(
                  padding: const EdgeInsets.fromLTRB(10, 5, 10, 0),
                  child: ListTile(
                    title: Text("E-Mail", style: textStyle),
                    subtitle: Text("kunlavut@gmail.com"),
                    leading: Icon(
                      Icons.email,
                      color: Color(AppData.purpleColor),
                    ),
                  ),
                ),
                Padding(
                  padding: const EdgeInsets.fromLTRB(10, 5, 10, 0),
                  child: ListTile(
                    title: Text("ช่องทางติดต่ออื่น ๆ", style: textStyle),
                    subtitle: Column(
                      children: <Widget>[
                        ListTile(
                          title: Text("Kunlavut",
                              style: TextStyle(
                                color: Color(AppData.greyColor),
                              )),
                          leading: Icon(
                            Zocial.facebook,
                            color: Colors.blue[700],
                            size: 18,
                          ),
                        ),
                        ListTile(
                          title: Text("@kunlavut",
                              style: TextStyle(
                                color: Color(AppData.greyColor),
                              )),
                          leading: Icon(
                            Zocial.twitter,
                            color: Colors.blue[700],
                            size: 18,
                          ),
                        ),
                      ],
                    ),
                    leading: Icon(
                      Icons.contacts,
                      color: Color(AppData.purpleColor),
                    ),
                  ),
                ),
                Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: <Widget>[
                    Container(
                      padding: EdgeInsets.fromLTRB(0, 30, 0, 15),
                      child: RaisedButton(
                        padding: EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
                        shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.circular(7),
                        ),
                        child: Text(
                          "บันทึก",
                          style: TextStyle(
                            fontWeight: FontWeight.w800,
                            color: Colors.white,
                            fontSize: 18,
                          ),
                        ),
                        color: Color(AppData.yellowColor),
                        onPressed: () {},
                      ),
                    ),
                    SizedBox(
                      width: 20,
                    ),
                    Container(
                      padding: EdgeInsets.fromLTRB(0, 30, 0, 15),
                      child: RaisedButton(
                        padding: EdgeInsets.only(top: 12, left: 30, right: 30, bottom: 12),
                        shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.circular(7),
                        ),
                        child: Text(
                          "ยกเลิก",
                          style: TextStyle(
                            fontWeight: FontWeight.w800,
                            color: Colors.white,
                            fontSize: 18,
                          ),
                        ),
                        color: Color(AppData.greyColor),
                        onPressed: () {
                          Navigator.of(context).popUntil((route) => route.isFirst);
                        },
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }

  CircleAvatar _buildAvatar(String image, {double radius = 80}) {
    return CircleAvatar(
      backgroundColor: Colors.white,
      radius: radius,
      child: CircleAvatar(
        radius: radius - 2,
        backgroundImage: AssetImage(image), //NetworkImage(image),
      ),
    );
  }
}
